/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.earth;

import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.ui.InvalidIdException;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.ui.UIObjectProperties;
import com.ibm.hwmca.fw.ui.UIObjectsReader;
import com.ibm.hwmca.fw.ui.UIObjectsWriter;
import com.ibm.hwmca.fw.ui.UIPropertyChangeSupport;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.ui.bonsai.config.ResourcesNodeConfigBean;
import com.ibm.hwmca.ui.bonsai.config.WorkareaConfigBean;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeManager;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeNode;
import com.ibm.hwmca.ui.bonsai.earth.ResourceMutableTreeNode;
import com.ibm.hwmca.ui.bonsai.earth.Targetable;
import com.ibm.hwmca.ui.bonsai.earth.util.UserRolePermissionsSet;
import com.ibm.hwmca.ui.bonsai.servlet.ControllerServlet;
import com.ibm.hwmca.ui.bonsai.servlet.util.TaskUrl;
import com.ibm.hwmca.ui.bonsai.servlet.util.UserObject;
import com.ibm.hwmca.ui.bonsai.table.AttentionsTableCellBean;
import com.ibm.hwmca.ui.bonsai.table.ExceptionTableCellBean;
import com.ibm.hwmca.ui.bonsai.table.NameTableCellBean;
import com.ibm.hwmca.ui.bonsai.table.StatusTableCellBean;
import java.beans.PropertyChangeEvent;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public final class ResourceMOTreeNode
extends ResourceMutableTreeNode
implements Targetable {
    private static final Set STATUS_PROPERTY_NAMES = new HashSet(10);
    private static final String TRACEMASK_T = "XBUIRMNT";
    private static final String TRACEMASK_F = "XBUIRMNF";
    private static final String TRACEMASK_D = "XBUIRMND";
    private static transient Comparator myComparator;
    private String shortId;
    private List columns;
    private UserRolePermissionsSet roleSet;

    protected ResourceMOTreeNode(ResourceMOTreeNode clonee, BonsaiTreeNode parent) {
        this(clonee, parent, clonee.getXMLKey() + "-" + clonee.shortId);
    }

    protected ResourceMOTreeNode(ResourceMOTreeNode clonee, BonsaiTreeNode parent, String idPostfix) {
        super(clonee, parent, idPostfix);
        this.shortId = clonee.shortId;
        this.columns = clonee.columns;
        this.roleSet = clonee.roleSet;
    }

    public ResourceMOTreeNode(ResourcesNodeConfigBean configBean, String shortId, List columns, Set properties, BonsaiTreeNode parent, WorkareaConfigBean defaultWorkarea, Set filters) {
        this(configBean, shortId, columns, properties, parent, defaultWorkarea, filters, configBean.getKey() + "-" + shortId);
    }

    public ResourceMOTreeNode(ResourcesNodeConfigBean configBean, String shortId, List columns, Set properties, BonsaiTreeNode parent, WorkareaConfigBean defaultWorkarea, Set filters, String idPostfix) {
        super(configBean, parent, defaultWorkarea, filters, idPostfix);
        this.shortId = shortId;
        this.columns = columns;
        ObjectId objId = UIObjectsWriter.getUIObjectsWriter().getShortObjectIdManager().getObjectId(shortId);
        if (objId == null) {
            throw new InvalidIdException("There is no object id yet!");
        }
        ControllerServlet.getUIObjectsReader().getBuffer(shortId);
        this.roleSet = new UserRolePermissionsSet(objId);
        this.setListener(new MOTreeNodeListener(properties));
    }

    public String getShortId() {
        return this.shortId;
    }

    public String getParentShortId() {
        BonsaiTreeNode parent = this.getParent();
        return parent instanceof Targetable ? ((Targetable)((Object)parent)).getShortId() : null;
    }

    protected String getClassTypeShortId(byte[] propBuffer) {
        return UIObjectProperties.getClassTypeShortId(propBuffer);
    }

    public String getClassTypeShortId() {
        return this.getClassTypeShortId(this.getMyPropertiesBuffer());
    }

    protected String getDefaultTaskUrl(byte[] propBuffer) {
        String taskShortId = UIObjectProperties.getOpenTaskShortId(propBuffer);
        if (taskShortId == null) {
            return null;
        }
        return new TaskUrl(taskShortId, 2, this.getShortId(), this.getParentShortId()).toString();
    }

    public String getDefaultTaskUrl() {
        return this.getDefaultTaskUrl(this.getMyPropertiesBuffer());
    }

    protected UIInfo getUIInfo(byte[] propBuffer) {
        UIInfo info = super.getUIInfo();
        if (info == null) {
            info = new UIInfo(UIObjectProperties.getName(propBuffer), UIObjectProperties.getCaption(propBuffer), UIObjectProperties.getImageName(propBuffer));
        }
        return info;
    }

    public UIInfo getUIInfo() {
        return this.getUIInfo(this.getMyPropertiesBuffer());
    }

    protected LocalizableText getStatus(byte[] propBuffer) {
        return UIObjectProperties.getStatusText(propBuffer);
    }

    public LocalizableText getStatus() {
        return this.getStatus(this.getMyPropertiesBuffer());
    }

    protected boolean hasAttentions(byte[] propBuffer) {
        return UIObjectProperties.attentionsExist(propBuffer);
    }

    public boolean hasAttentions() {
        return this.hasAttentions(this.getMyPropertiesBuffer());
    }

    protected boolean isStatusAcceptable(byte[] propBuffer) {
        return UIObjectProperties.isStatusAcceptable(propBuffer);
    }

    public boolean isStatusAcceptable() {
        return this.isStatusAcceptable(this.getMyPropertiesBuffer());
    }

    protected boolean isLocked(byte[] propBuffer) {
        return UIObjectProperties.isLocked(propBuffer);
    }

    public boolean isLocked() {
        return this.isLocked(this.getMyPropertiesBuffer());
    }

    protected boolean isBusy(byte[] propBuffer) {
        return UIObjectProperties.isBusy(propBuffer);
    }

    public boolean isBusy() {
        return this.isBusy(this.getMyPropertiesBuffer());
    }

    protected String getStatusTaskUrl(byte[] propBuffer) {
        if (this.isStatusAcceptable(propBuffer) && !this.hasAttentions(propBuffer)) {
            return null;
        }
        String taskShortId = UIObjectProperties.getAttentionTaskShortId(propBuffer);
        if (ControllerServlet.getUIObjectsReader().getAllowedTasks(this.shortId).contains(taskShortId)) {
            return new TaskUrl(taskShortId, 2, this.getShortId(), this.getParentShortId()).toString();
        }
        return null;
    }

    public String getStatusTaskUrl() {
        return this.getStatusTaskUrl(this.getMyPropertiesBuffer());
    }

    public boolean isPermitted(Set userRoles) {
        return this.roleSet.isPermitted(userRoles);
    }

    public Map getTableProperties(UserObject userObj) {
        Set propKeys = this.columns == null ? TABLE_PROPERTIES : new HashSet(this.columns);
        byte[] buffer = this.getMyPropertiesBuffer();
        Locale locale = userObj.getLocale();
        UIInfo uiInfo = this.getUIInfo(buffer);
        String statusTaskUrl = null;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        String key = null;
        Iterator i = propKeys.iterator();
        while (i.hasNext()) {
            key = (String)i.next();
            if (key.equals("Name")) {
                properties.put(key, new NameTableCellBean(uiInfo.getName(locale), this.getDefaultTaskUrl(buffer), uiInfo.getImageURL(), uiInfo.getImageName(), this.isLocked(buffer), this.isBusy(buffer), this.getId()));
                continue;
            }
            if (key.equals("Status")) {
                if (statusTaskUrl == null) {
                    statusTaskUrl = this.getStatusTaskUrl(buffer);
                }
                properties.put(key, new StatusTableCellBean(this.getShortId(), this.getStatus(buffer).toString(locale), this.isStatusAcceptable(buffer), this.hasAttentions(buffer), statusTaskUrl));
                continue;
            }
            if (key.equals("Acceptable")) {
                if (statusTaskUrl == null) {
                    statusTaskUrl = this.getStatusTaskUrl(buffer);
                }
                properties.put(key, new ExceptionTableCellBean(this.getShortId(), this.isStatusAcceptable(buffer), statusTaskUrl));
                continue;
            }
            if (key.equals("AttentionsExist")) {
                if (statusTaskUrl == null) {
                    statusTaskUrl = this.getStatusTaskUrl(buffer);
                }
                properties.put(key, new AttentionsTableCellBean(this.getShortId(), this.hasAttentions(buffer), statusTaskUrl));
                continue;
            }
            if (key.equals("Caption")) {
                properties.put(key, uiInfo.getCaption(locale));
                continue;
            }
            i.remove();
            Trace.trace(TRACEMASK_F, "Configuration Error!  Unknown key (" + key + ")!");
        }
        properties.put("id", this.getId());
        return properties;
    }

    public BonsaiTreeNode getCopy(BonsaiTreeNode parent, boolean copyChildren) {
        ResourceMOTreeNode node = new ResourceMOTreeNode(this, parent);
        if (copyChildren) {
            node.copyChildren(this);
        }
        return node;
    }

    private Set getChildrenByShortId(String shortId) {
        HashSet<BonsaiTreeNode> children = new HashSet<BonsaiTreeNode>(1);
        BonsaiTreeNode child = null;
        Iterator i = this.getChildren().iterator();
        while (i.hasNext()) {
            child = (BonsaiTreeNode)i.next();
            if (!(child instanceof Targetable) || !((Targetable)((Object)child)).getShortId().equals(shortId)) continue;
            children.add(child);
        }
        return children;
    }

    private byte[] getMyPropertiesBuffer() {
        return ControllerServlet.getUIObjectsReader().getBuffer(this.getShortId());
    }

    public static Comparator getComparator() {
        return myComparator;
    }

    static {
        STATUS_PROPERTY_NAMES.add("AttentionsExist");
        STATUS_PROPERTY_NAMES.add("StatusAcceptable");
        STATUS_PROPERTY_NAMES.add("AttentionsExist");
        STATUS_PROPERTY_NAMES.add("Busy");
        STATUS_PROPERTY_NAMES.add("Locked");
        STATUS_PROPERTY_NAMES.add("StatusAcceptable");
        STATUS_PROPERTY_NAMES.add("Status");
        myComparator = new MyComparator();
    }

    private static class MyComparator
    implements Comparator {
        public int compare(Object obj1, Object obj2) {
            ResourceMOTreeNode node1 = (ResourceMOTreeNode)obj1;
            ResourceMOTreeNode node2 = (ResourceMOTreeNode)obj2;
            int result = node1.getUIInfo().getName().compareTo(node2.getUIInfo().getName());
            if (result == 0) {
                result = node1.getId().compareTo(node2.getId());
            }
            return result;
        }

        public boolean equals(Object obj) {
            return obj instanceof MyComparator;
        }
    }

    private class MOTreeNodeListener
    extends ResourceMutableTreeNode.AbstractTreeNodeListener {
        private Set properties;

        private MOTreeNodeListener(Set properties) {
            super(ResourceMOTreeNode.this, ResourceMOTreeNode.this);
            this.properties = properties;
        }

        protected synchronized void register() {
            UIPropertyChangeSupport registry = UIObjectsWriter.getUIObjectsWriter().getUIPropertyChangeSupport();
            Iterator i = this.properties.iterator();
            while (i.hasNext()) {
                registry.addPropertyChangeListener((String)i.next(), ResourceMOTreeNode.this.shortId, this);
            }
        }

        protected synchronized void deregister() {
            UIPropertyChangeSupport registry = UIObjectsWriter.getUIObjectsWriter().getUIPropertyChangeSupport();
            registry.removeAllPropertyChangeListener(this);
            registry.removeInventoryListener(this);
        }

        public synchronized void propertyChange(PropertyChangeEvent event) {
            try {
                String propertyName = event.getPropertyName();
                Trace.trace(ResourceMOTreeNode.TRACEMASK_F, "--> ResourceMOTreeNode.propertyChange(" + propertyName + ") [node='" + ResourceMOTreeNode.this.getId() + "']");
                BonsaiTreeManager manager = BonsaiTreeManager.getBonsaiTreeManager();
                if (propertyName.equals("InventoryProperty")) {
                    Trace.trace(ResourceMOTreeNode.TRACEMASK_D, "property change for inventory - rebuilding this branch (" + ResourceMOTreeNode.this.getId() + ")");
                    try {
                        manager.rebuildBranch(this.getOwner());
                        UIObjectsWriter.getUIObjectsWriter().getUIPropertyChangeSupport().removeInventoryListener(this);
                    }
                    catch (InvalidIdException iiEx) {}
                } else if (propertyName.equals("Children")) {
                    String[] shortIds = null;
                    shortIds = (String[])event.getOldValue();
                    if (shortIds != null) {
                        for (int i = 0; i < shortIds.length; ++i) {
                            Trace.trace(ResourceMOTreeNode.TRACEMASK_D, "property change for remove child with short id: " + shortIds[i]);
                            Iterator j = ((ResourceMOTreeNode)this.getOwner()).getChildrenByShortId(shortIds[i]).iterator();
                            while (j.hasNext()) {
                                manager.removeBranch((BonsaiTreeNode)j.next());
                            }
                        }
                    } else {
                        shortIds = (String[])event.getNewValue();
                        if (shortIds != null) {
                            Trace.trace(ResourceMOTreeNode.TRACEMASK_D, "property change for add children - rebuilding this branch (" + ResourceMOTreeNode.this.getId() + ")");
                            try {
                                UIObjectsReader reader = ControllerServlet.getUIObjectsReader();
                                for (int i = 0; i < shortIds.length; ++i) {
                                    reader.getBuffer(shortIds[i]);
                                }
                                manager.rebuildBranch(this.getOwner());
                            }
                            catch (InvalidIdException iiEx) {
                                UIObjectsWriter.getUIObjectsWriter().getUIPropertyChangeSupport().addInventoryListener(this);
                            }
                        }
                    }
                } else if (propertyName.equals("UIInfo")) {
                    Trace.trace(ResourceMOTreeNode.TRACEMASK_D, "property change for ui info - notifying manager (" + ResourceMOTreeNode.this.getId() + ")");
                    manager.uiinfoChange(this.getOwner());
                } else if (STATUS_PROPERTY_NAMES.contains(propertyName)) {
                    Trace.trace(ResourceMOTreeNode.TRACEMASK_D, "property change for status (" + propertyName + ") - notifying manager (" + ResourceMOTreeNode.this.getId() + ")");
                    manager.statusChange(this.getOwner());
                }
            }
            catch (Exception ex) {
                Trace.trace(ResourceMOTreeNode.TRACEMASK_F, "Exception: " + ex.toString());
            }
            Trace.trace(ResourceMOTreeNode.TRACEMASK_F, "<-- ResourceMOTreeNode.propertyChange()");
        }
    }
}

